Page({
  data: {
    isShowEmpty: false,
    isShowFeedback: false,
    channelMd5: '',
    huoma: {},
    subHuoma: {}
  },

  onLoad(options) {
    let that = this;
    
    let id = options.id || 0;
    let sn = options.sn || 0;
    let channelMd5 = options.channel_md5 || '';
    let lastid = wx.getStorageSync('lastid') || 0;

    that.setData({
        'channelMd5': channelMd5
    });

    wx.hideShareMenu();

      if (id != 0) {
          wx.request({
              url: 'https://www.wzsd.cc/mkt/subhuoma/getSubhuomaInfo',
              data: {
                  'id': id,
                  'sn': sn,
                  'lastid': lastid,
                  'channel_md5': that.data.channelMd5
              },
              success: (res) => {
                  if (res.data.status == 1) {
                      that.setData({
                          'huoma': res.data.data.huoma,
                          'subHuoma': res.data.data.subHuoma
                      });

                      wx.setNavigationBarTitle({
                          title: res.data.data.huoma.title
                      });

                      wx.setStorageSync('lastid', res.data.data.subHuoma.id);
                  }
                  else if (res.data.status == 0) {
                      that.setData({
                          isShowEmpty: true
                      });
                  }
                  else {
                      wx.navigateTo({
                          url: '/pages/index/index',
                      });
                  }
              },
              complete: () => {
                  setTimeout(function () {
                      that.setData({
                          isShowEmpty: true
                      });
                  }, 1000);
              }
          });
      }
      else {
          that.setData({
              isShowFeedback: true
          });
      }
    },
  handleSubmit: function (event) {
      if (event.detail.value.feedback == '') {
          wx.showToast({
              icon: 'error',
              title: '请填写内容',
          });
          return false;
      }
      else {
          wx.showToast({
              icon: 'success',
              title: '提交成功',
          });
      }
    },
  trackLog(){
    let that = this;
    wx.request({
      url: 'https://www.wzsd.cc/mkt/subhuoma/addscannum',
      data: {
          'id': that.data.subHuoma.id, 
          'channel_md5': that.data.channelMd5
      }
    });
  }
})